/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContentEvent;
import filenet.vw.apps.taskman.VWTaskContentListener;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;

public class VWTaskToolBar
extends JToolBar
implements ActionListener,
VWTaskContentListener {
    private EventListenerList m_listenerList = new EventListenerList();
    public JButton m_actionButton = null;
    public JButton m_viewButton = null;
    public AbstractButton m_startButton = null;
    public AbstractButton m_stopButton = null;
    public AbstractButton m_deleteButton = null;
    public AbstractButton m_refreshButton = null;
    public AbstractButton m_upButton = null;
    public AbstractButton m_helpButton = null;

    public VWTaskToolBar() {
        try {
            this.setFloatable(false);
            this.setBorderPainted(false);
            this.createButtons();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void disable() {
        this.m_startButton.setEnabled(false);
        this.m_stopButton.setEnabled(false);
        this.m_deleteButton.setEnabled(false);
        this.m_refreshButton.setEnabled(false);
        this.m_upButton.setEnabled(false);
        this.m_helpButton.setEnabled(false);
    }

    protected void createButtons() {
        try {
            this.m_startButton = VWImageLoader.createToolBarButton("start.gif", VWTaskActionCommand.START, false);
            this.add(this.m_startButton);
            this.m_startButton.addActionListener(this);
            this.m_startButton.setActionCommand(VWTaskActionCommand.START);
            this.m_startButton.setEnabled(false);
            this.m_startButton.setRolloverEnabled(true);
            VWAccessibilityHelper.setAccessibility(this.m_startButton, this, VWTaskActionCommand.START, VWTaskActionCommand.START);
            this.m_stopButton = VWImageLoader.createToolBarButton("stop.gif", VWTaskActionCommand.STOP, false);
            this.add(this.m_stopButton);
            this.m_stopButton.addActionListener(this);
            this.m_stopButton.setActionCommand(VWTaskActionCommand.STOP);
            this.m_stopButton.setEnabled(false);
            this.m_stopButton.setRolloverEnabled(true);
            VWAccessibilityHelper.setAccessibility(this.m_stopButton, this, VWTaskActionCommand.STOP, VWTaskActionCommand.STOP);
            this.m_deleteButton = VWImageLoader.createToolBarButton("delete.gif", VWTaskActionCommand.DELETE, false);
            this.add(this.m_deleteButton);
            this.m_deleteButton.addActionListener(this);
            this.m_deleteButton.setActionCommand(VWTaskActionCommand.DELETE);
            this.m_deleteButton.setEnabled(false);
            this.m_deleteButton.setRolloverEnabled(true);
            VWAccessibilityHelper.setAccessibility(this.m_deleteButton, this, VWTaskActionCommand.DELETE, VWTaskActionCommand.DELETE);
            VWImageLoader.addToolbarSeparator(this);
            this.m_refreshButton = VWImageLoader.createToolBarButton("refresh.gif", VWTaskActionCommand.REFRESH, false);
            this.add(this.m_refreshButton);
            this.m_refreshButton.addActionListener(this);
            this.m_refreshButton.setActionCommand(VWTaskActionCommand.REFRESH);
            this.m_refreshButton.setEnabled(true);
            this.m_refreshButton.setRolloverEnabled(true);
            VWAccessibilityHelper.setAccessibility(this.m_refreshButton, this, VWTaskActionCommand.REFRESH, VWTaskActionCommand.REFRESH);
            this.m_upButton = VWImageLoader.createToolBarButton("up.gif", VWTaskActionCommand.UP, false);
            this.add(this.m_upButton);
            this.m_upButton.addActionListener(this);
            this.m_upButton.setActionCommand(VWTaskActionCommand.UP);
            this.m_upButton.setEnabled(true);
            this.m_upButton.setRolloverEnabled(true);
            VWAccessibilityHelper.setAccessibility(this.m_upButton, this, VWTaskActionCommand.UP, VWTaskActionCommand.UP);
            VWImageLoader.addToolbarSeparator(this);
            this.m_helpButton = VWImageLoader.createToolBarButton("help.gif", VWTaskActionCommand.HELP_TOPICS, false);
            this.add(this.m_helpButton);
            this.m_helpButton.addActionListener(this);
            this.m_helpButton.setActionCommand(VWTaskActionCommand.HELP_TOPICS);
            this.m_helpButton.setEnabled(true);
            this.m_helpButton.setRolloverEnabled(true);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWTaskActionCommand.HELP_TOPICS, VWTaskActionCommand.HELP_TOPICS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addActionListener(ActionListener al) {
        this.m_listenerList.add(ActionListener.class, al);
    }

    public void removeActionListener(ActionListener al) {
        this.m_listenerList.remove(ActionListener.class, al);
    }

    private void fireActionEvent(ActionEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            this.fireActionEvent(ae);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void taskContentChanged(VWTaskContentEvent evt) {
        VWTaskBaseNode node = evt.getBaseNode();
        this.m_startButton.setEnabled(node.showStartIcon());
        this.m_stopButton.setEnabled(node.showStopIcon());
        this.m_deleteButton.setEnabled(node.showDeleteIcon());
        this.m_refreshButton.setEnabled(true);
        this.m_upButton.setEnabled(true);
        this.m_helpButton.setEnabled(true);
    }

    public static String _get_FILE_DATE() {
        return "$Date:   17 May 2006 13:34:52  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.3  $";
    }
}

